/**
 * @file        TimeControl.cpp
 * @brief       Common time functions.
 * @since       30.09.2020
 * @copyright   Copyright 2020 dSPACE GmbH. All rights reserved.
 */

 /*----------------------------------------------------------------------------*/
 /* INCLUDES                                                                   */
 /*----------------------------------------------------------------------------*/

#include "TimeControl.h"

#if (defined(DS_PLATFORM_SMARTHIL) || defined(DS_PLATFORM_SMARTBOX)) && !defined(HOST_DEBUG)
#include <DsTimer.h>
#elif defined(DS_PLATFORM_OFFSIM)
#else 
#error "Unknown Platform"
#endif

/*----------------------------------------------------------------------------*/
/* DEFINES                                                                    */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* GLOBAL VARIABLES                                                           */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* GLOBAL FUNCTIONS                                                           */
/*----------------------------------------------------------------------------*/

double TimeControl_getTime(void)
{
#if (defined(DS_PLATFORM_SMARTHIL) || defined(DS_PLATFORM_SMARTBOX)) && !defined(HOST_DEBUG)
    return DsCTime::getCurrentHwTime();
#else 
    // getCurrentHwTime is not supported
    return 0;
#endif
}

/*----------------------------------------------------------------------------*/
/* END OF FILE                                                                */
/*----------------------------------------------------------------------------*/
